/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis.mega;

import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_VacuumFreezer;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class GT_TileEntity_MegaVacuumFreezer
extends GT_MetaTileEntity_VacuumFreezer {
    public GT_TileEntity_MegaVacuumFreezer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_MegaVacuumFreezer(String aName) {
        super(aName);
    }

    public String[] getDescription() {
        String[] dsc = StatCollector.translateToLocal((String)"tooltip.tile.mvf.0.name").split(";");
        String[] fdsc = new String[dsc.length + 1];
        for (int i = 0; i < dsc.length; ++i) {
            fdsc[i] = dsc[i];
            fdsc[dsc.length] = StatCollector.translateToLocal((String)"tooltip.bw.1.name") + "\u00a72" + " BartWorks";
        }
        return fdsc;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_TileEntity_MegaVacuumFreezer(this.mName);
    }

    public boolean drainEnergyInput(long aEU) {
        if (aEU <= 0L) {
            return true;
        }
        long allTheEu = 0L;
        int hatches = 0;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            allTheEu += tHatch.getEUVar();
            ++hatches;
        }
        if (allTheEu < aEU) {
            return false;
        }
        long euperhatch = aEU / (long)hatches;
        HashSet<Boolean> returnset = new HashSet<Boolean>();
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (tHatch.getBaseMetaTileEntity().decreaseStoredEnergyUnits(euperhatch, false)) {
                returnset.add(true);
                continue;
            }
            returnset.add(false);
        }
        return returnset.size() > 0 && !returnset.contains(false);
    }

    public boolean checkRecipe(ItemStack itemStack) {
        int processed;
        ItemStack[] tInputs = this.getStoredInputs().toArray(new ItemStack[0]);
        ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>();
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sVacuumRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], null, tInputs);
        boolean found_Recipe = false;
        long nominalV = BW_Util.getnominalVoltage((GT_MetaTileEntity_MultiBlockBase)this);
        for (processed = 0; this.getStoredInputs().size() > 0 && processed < ConfigHandler.megaMachinesMax && tRecipe != null && (long)(tRecipe.mEUt * (processed + 1)) < nominalV && tRecipe.isRecipeInputEqual(true, null, tInputs); ++processed) {
            found_Recipe = true;
            for (int i = 0; i < tRecipe.mOutputs.length; ++i) {
                outputItems.add(tRecipe.getOutput(i));
            }
        }
        if (found_Recipe) {
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            long actualEUT = (long)tRecipe.mEUt * (long)processed;
            if (actualEUT > Integer.MAX_VALUE) {
                int divider = 0;
                while (actualEUT > Integer.MAX_VALUE) {
                    actualEUT /= 2L;
                    divider = (byte)(divider + 1);
                }
                BW_Util.calculateOverclockedNessMulti((int)(actualEUT / (long)(divider * 2)), tRecipe.mDuration * (divider * 2), 1, nominalV, (GT_MetaTileEntity_MultiBlockBase)this);
            } else {
                BW_Util.calculateOverclockedNessMulti((int)actualEUT, tRecipe.mDuration, 1, nominalV, (GT_MetaTileEntity_MultiBlockBase)this);
            }
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                return false;
            }
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            this.mOutputItems = new ItemStack[outputItems.size()];
            this.mOutputItems = outputItems.toArray(this.mOutputItems);
            this.updateSlots();
            return true;
        }
        return false;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return BW_Util.check_layer(aBaseMetaTileEntity, 7, -7, -6, GregTech_API.sBlockCasings2, 1, 7, false, false, true, GregTech_API.sBlockCasings2, 1, true, 17) && BW_Util.check_layer(aBaseMetaTileEntity, 7, -6, 0, GregTech_API.sBlockCasings2, 1, 7, false, false, true, Blocks.air, -1, true, 17) && BW_Util.check_layer(aBaseMetaTileEntity, 7, 0, 1, GregTech_API.sBlockCasings2, 1, 7, true, false, true, Blocks.air, -1, true, 17) && BW_Util.check_layer(aBaseMetaTileEntity, 7, 1, 7, GregTech_API.sBlockCasings2, 1, 7, false, false, true, Blocks.air, -1, true, 17) && BW_Util.check_layer(aBaseMetaTileEntity, 7, 7, 8, GregTech_API.sBlockCasings2, 1, 7, false, false, true, GregTech_API.sBlockCasings2, 1, true, 17) && !this.mInputBusses.isEmpty() && !this.mOutputBusses.isEmpty() && !this.mEnergyHatches.isEmpty() && !this.mMaintenanceHatches.isEmpty();
    }
}

